/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.daemons;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.daemons.DaemonParameterKeys;
import com.ibm.hwmca.fw.daemons.DaemonParameters;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;

public class SambaController
implements DaemonParameterKeys {
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(48, "SambaCtrl");
    public static final int SAMBA_START = 0;
    public static final int SAMBA_STOP = 1;
    private static final String TRACE_MASKT = "XDAESMBT";
    private static final String TRACE_MASKF = "XDAESMBF";
    private static final String TRACE_MASKD = "XDAESMBD";
    private static final short SAMBA_CONTROL_ERROR = 639;

    public SambaController() {
        Trace.trace(TRACE_MASKT, "<> SambaController.ctor()");
    }

    public static void sambaAction(int actionCode) throws HException {
        Trace.trace(TRACE_MASKT, "-> SambaController.controlSamba()");
        DaemonParameters _parameters = DaemonParameters.getDaemonParameters();
        String command = actionCode == 0 ? "start" : "stop";
        String[] ctrlSAMBA = new String[]{_parameters.getParm("daemon.smb.script"), command, _parameters.getParm("daemon.log.dir") + _parameters.getParm("daemon.log")};
        try {
            int rc = RootProcess.executeProgram(ctrlSAMBA);
            Trace.trace(TRACE_MASKF, ctrlSAMBA[0] + " completed with rc=" + rc);
            if (rc != 0) {
                throw new HException("couldn't " + command + " SAMBA server, return code: " + rc);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "sambaAction(): " + exc.getMessage());
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 639, hexc).log();
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- SambaController.sambaAction()");
    }
}

